IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='EST_ORC_CPL_PBM') 
BEGIN
	CREATE TABLE EST_ORC_CPL_PBM(
		CD_EMP INT,
        CD_FILIAL INT,
        CD_ORC INT,
        CD_IT INT,
        ID_TERMINAL VARCHAR(100) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS,
        NSU_REQ VARCHAR(100) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS,
        NUMERO_SESSAO VARCHAR(100) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS,
        CD_PROJETO_EXT BIGINT,
        CGC_CPF VARCHAR(20) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS,
        PERC_DESC_UNIT_PBM MONEY,
        VLR_DESC_UNIT_PBM MONEY,
        VLR_UNIT_PBM MONEY,
        FLAG_UPLOAD_RECEITA_MEDICA SMALLINT,
        FLAG_EXIGE_RECEITA_MEDICA SMALLINT,
        ID_CAMPANHA INT,
        PRE_AUTORIZACAO VARCHAR(100) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS,
        NUMERO_AUTORIZACAO VARCHAR(100) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS,
        TIPO_PBM INT,
		CD_PROJETO INT,
		NR_CARTAO_CLI VARCHAR(100),
		CNPJ_PROJETO_PBM VARCHAR(20)
	PRIMARY KEY CLUSTERED (CD_EMP, CD_FILIAL, CD_ORC, CD_IT ASC) 
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_ORC_CPL_PBM]  WITH CHECK 
		ADD CONSTRAINT [FK_EST_ORC_CPL_PBM_EST_ORC_CPL] FOREIGN KEY(CD_EMP, CD_FILIAL, CD_ORC, CD_IT)
		REFERENCES [dbo].[EST_ORC_CPL] (CD_EMP, CD_FILIAL, CD_ORC, CD_IT)
END